
' Leatrix Latency Fix Checker
' To use, simply run this script.
' To run from within batch files, use 'cscript Checker.vbs"

  logo = "Leatrix Latency Fix Checker"
  Leatrix_Version = "1.15"

  Const HKEY_LOCAL_MACHINE = &H80000002

  Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\.\root\default:StdRegProv")
  strKeyPath = "SYSTEM\CurrentControlSet\Services\Tcpip\Parameters\Interfaces\"
  oReg.EnumKey HKEY_LOCAL_MACHINE, strKeyPath, arrSubKeys

  If Instr(1, WScript.FullName, "cscript", vbTextCompare) > 1 Then
    Leatrix_Script = 1
  End If

  if Leatrix_Script = 1 then
    wscript.echo "Leatrix Latency Fix " & Leatrix_Version & " Batch Mode."
    wscript.echo ""
  end if

' Latency fix has already been applied
  if CheckFix = true then
    msg = "Leatrix Latency Fix is installed on this computer."
    if Leatrix_Script = 0 then
      msg = msgbox (msg,64,logo)
    else
      wscript.echo msg
    end if
  else
    msg = "Leatrix Latency Fix is not installed on this computer."
    if Leatrix_Script = 0 then
      msg = msgbox (msg,48,logo)
    else
      wscript.echo msg
    end if
  end if
  wscript.quit

  Function CheckFix()
  ' Checks to see if any of the settings have been applied
    StopCheck = 0
    For Each subkey In arrSubKeys
      oReg.GetDWORDValue HKEY_LOCAL_MACHINE,strKeyPath & subkey,"TcpAckFrequency",CheckFix
      if CheckFix = 1 then 
      else StopCheck = 1
      end if
    Next
    if StopCheck = 1 then CheckFix = false else CheckFix = true
  end function
